package fr.a4.portail_coulissant;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;

import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;

//application pour piloter le portail coulissant automatique A4
//Utiliser le fichier portail_coulissant_wifi_sans_capteur.plf
//Cette application permet d'envoyer une commande d'ouverture ou fermeture  la carte wifi picaxe
//L'application fonctionne sans retour d'information du module picaxe (sans capteur)
//Pour cela les moteurs fonctionnent pendant un temps d'attente paramtrable par un timer interne au smartphone
//le temps d'attente devra tre le mme entre le programme picaxe et le smartphone


public class MainActivity extends Activity {

	TextView connexion,portail,temps_attente,text_attente,unite_attente;
	ImageButton ouvrir,fermer;
	EditText temps_ouvre_ferme;
	
	
	private static final byte code_vantail_ferme = 70; //correcpond au code ascii de F
	private static final byte code_vantail_ouvert = 79; //correcpond au code ascii de O
	
	Timer t;
	int temps,temps_attente_ouvre_ferme=0;
	boolean sens=false; //sens=false= fermeture, =true=ouverture
	NetworkTask networktask;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		temps_attente=(TextView)findViewById(R.id.temps_attente);
		text_attente=(TextView)findViewById(R.id.attente_texte);
		unite_attente=(TextView)findViewById(R.id.unite_attente);
		connexion=(TextView)findViewById(R.id.etat_connexion);
		portail=(TextView)findViewById(R.id.statut_portail);
		ouvrir=(ImageButton)findViewById(R.id.b_ouvrir);
		fermer=(ImageButton)findViewById(R.id.b_fermer);
		temps_ouvre_ferme=(EditText)findViewById(R.id.temps_ouvre_ferme);
		ouvrir.setOnClickListener(ouvrir_listener);
		fermer.setOnClickListener(fermer_listener);
		
		fermer.setClickable(false);
		ouvrir.setClickable(true);// portail ferm au dpart!
		temps_attente_ouvre_ferme=Integer.parseInt(temps_ouvre_ferme.getText().toString())*10;
		
		networktask = new NetworkTask();
		networktask.execute();
	}

	private OnClickListener ouvrir_listener = new OnClickListener() {
		public void onClick(View v){
			portail.setText(" ouverture...");
			networktask.SendDataToNetwork((byte)code_vantail_ouvert);
			ouvrir.setClickable(false);
			
			sens=true;
			timerstart();
		}
	};
	
	private OnClickListener fermer_listener = new OnClickListener() {
		public void onClick(View v){
			portail.setText(" fermeture...");
			networktask.SendDataToNetwork((byte)code_vantail_ferme);
			fermer.setClickable(false);
			sens=false;
			timerstart();
		}
	};
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	//timer pour compter le temps d'ouverture et de fermeture
	public void timerstart() {
		
		t= new Timer();
		t.scheduleAtFixedRate(new TimerTask() {
	        @Override
	        public void run() {
	            // TODO Auto-generated method stub
	            runOnUiThread(new Runnable() {
	                public void run() {
	                	temps_attente_ouvre_ferme=Integer.parseInt(temps_ouvre_ferme.getText().toString())*10;
	                	temps_attente.setText(String.valueOf(temps/10)); // you can set it to a textView to show it to the user to see the time passing while he is writing.
	    				temps+=2; //on ajoute 200ms
	    				if (temps>temps_attente_ouvre_ferme) {
	    					temps=0;
	    					if (sens) {
	    						portail.setText(" portail ouvert");
	    						fermer.setClickable(true);
	    					}
	    					else {
	    						portail.setText(" portail ferm");
	    						ouvrir.setClickable(true);
	    					}
	    					
	    					t.cancel();
	    				}
	                }
	            });

	        }
	    }, 0, 200);
	}
	
	public class NetworkTask extends AsyncTask<Void, byte[], Boolean> {
		
		Socket nsocket; //Network Socket
		InputStream nis; //Network Input Stream
		OutputStream nos; //Network Output Stream 
		@Override
		protected void onPreExecute() {
		}
		@Override
		// >>> Partie executee dans un autre Thread >>>>
	    protected Boolean doInBackground(Void... params) { 
	        boolean result = false;
	        try {
	        		SocketAddress sockaddr = new InetSocketAddress("192.168.16.254", 5000);
	        		nsocket = new Socket();
	        		nsocket.connect(sockaddr, 5000); //5 seconds connection timeout
	        		if (nsocket.isConnected()) { 
	        			connexion.setText("Connecte au portail");
	        			nis = nsocket.getInputStream();
	        			nos = nsocket.getOutputStream();
	        			byte[] buffer = new byte[4096];
	        			int read = nis.read(buffer, 0, 4096); 
	        			while(read != -1){
	        				byte[] tempdata = new byte[read];
	        				System.arraycopy(buffer, 0, tempdata, 0, read);
	        				publishProgress(tempdata);
	        				read = nis.read(buffer, 0, 4096); 
	        			} 
	            }
	        } catch (IOException e) {
	            e.printStackTrace();
	            result = true;
	        } catch (Exception e) {
	            e.printStackTrace();
	            result = true;
	        } finally {
	            try {
	                nis.close();
	                nos.close();
	                nsocket.close();
	            } catch (IOException e) {
	                e.printStackTrace();
	            } catch (Exception e) {
	                e.printStackTrace();
	            }
	        }
	        return result;
	    } // <<< doInBackground <<<<<<<<<<<<<<<<<<<<<<<<<<<<
	
		public void SendDataToNetwork(byte commande_portail) {
		String cmd=""; // "i" caractre de synchro de dpart de tramme envoye
		try {
			if (nsocket.isConnected()) {
				//on fabrique la trame de commande
				cmd=(char)commande_portail+ cmd;	
				nos.write(cmd.getBytes());
			} else {
				connexion.setText("Socket ferm.");
			}
		} catch (Exception e) {
			connexion.setText("erreur socket");
			}
		}

		@Override
		protected void onProgressUpdate(byte[]... values) {
			
			if (values.length >0) {
				if (values[0].length>=1) { // on vrifie que l'on a bien reu 1 octets
			
					byte val = values[0][0];
					
					switch (val) {
						case code_vantail_ferme: { // si capteur ferm actif = portail ferm
							
							break;
						}
						case code_vantail_ouvert:{ // si capteur ouvert actif = portail ouvert
							
							break;
						}
					}
				}
			}
		}

		@Override
		protected void onPostExecute(Boolean result) {
			if (result) {
				connexion.setText("Erreur de connexion.");          
			}
		}
	} // <<< NetworkTask <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	@Override
	protected void onDestroy() {
		super.onDestroy();
		networktask.cancel(true);
	}

}
