/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class LoopBlock
extends TranslatorBlock {
    public LoopBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String ret = "void loop()\n{\n";
        if (this.translator.isGuinoProgram()) {
            ret = String.valueOf(ret) + "GUINO_GERER_INTERFACE();\n";
        }
        TranslatorBlock translatorBlock = this.getTranslatorBlockAtSocket(0);
        while (translatorBlock != null) {
            ret = String.valueOf(ret) + translatorBlock.toCode();
            translatorBlock = translatorBlock.nextTranslatorBlock();
        }
        if (this.translator.isScoopProgram()) {
            ret = String.valueOf(ret) + "yield();\n";
        }
        ret = String.valueOf(ret) + "}\n\n";
        return ret;
    }
}

