/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.util.codegen;

import com.ardublock.util.codegen.BlockDescription;
import com.ardublock.util.codegen.OutputSet;
import com.ardublock.util.codegen.XlsReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGen {
    private String digitalInputBlockGenusTemplate;
    private String digitalOutputBlockGenusTemplate;
    private String blockDrawerTemplate;
    private static String DIGITAL_INPUT_BLOCK_GENUS_TEMPLATE_PATH = "codegen/digitalinput.xml";
    private static String DIGITAL_OUTPUT_BLOCK_GENUS_TEMPLATE_PATH = "codegen/digitaloutput.xml";
    private static String BLOCK_DRAWER_TEMPLATE_PATH = "codegen/block_drawer.xml";

    public static void main(String[] args) throws InvalidFormatException, IOException {
        CodeGen a = new CodeGen();
        a.work();
    }

    public void work() throws InvalidFormatException, IOException {
        this.setupTemplateString();
        XlsReader xlsReader = new XlsReader();
        xlsReader.setFilePath("/home/heqichen/my/project/taweili/ardublock/ardublock/src/test/resources/seeedstudio/digitalout.xls");
        OutputSet outputSet = new OutputSet();
        this.generateArdublockCode(xlsReader, outputSet);
        this.output(outputSet);
    }

    private void setupTemplateString() throws IOException {
        this.digitalInputBlockGenusTemplate = this.loadStringFromClasspath(DIGITAL_INPUT_BLOCK_GENUS_TEMPLATE_PATH);
        this.digitalOutputBlockGenusTemplate = this.loadStringFromClasspath(DIGITAL_OUTPUT_BLOCK_GENUS_TEMPLATE_PATH);
        this.blockDrawerTemplate = this.loadStringFromClasspath(BLOCK_DRAWER_TEMPLATE_PATH);
    }

    private String loadStringFromClasspath(String pathInClasspath) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(pathInClasspath);
        String ret = null;
        try {
            ret = IOUtils.toString((InputStream)is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return ret;
    }

    private void generateArdublockCode(XlsReader xlsReader, OutputSet outputSet) throws InvalidFormatException, IOException {
        xlsReader.reset();
        while (xlsReader.hasNext()) {
            BlockDescription block = xlsReader.nextBlockDescription();
            this.putToOutputSet(block, outputSet);
        }
    }

    private void putToOutputSet(BlockDescription block, OutputSet outputSet) {
        outputSet.addBlockGenus(this.makeBlockGenusFromBlockDescription(block));
        outputSet.addBlockMember(this.makeBlockMemberFromBlockDescription(block));
        outputSet.addBlockName("bg." + block.getBlockGenusName() + "=" + block.getBlockShowName());
        outputSet.addBlockDescription("bg." + block.getBlockGenusName() + ".description=" + block.getBlockDescription());
        outputSet.addBlockType(String.valueOf(block.getBlockGenusName()) + "=" + block.getBlockType());
    }

    private String makeBlockMemberFromBlockDescription(BlockDescription block) {
        String ret = this.blockDrawerTemplate;
        ret = ret.replaceAll("#block_name#", block.getBlockGenusName());
        return ret;
    }

    private String makeBlockGenusFromBlockDescription(BlockDescription block) {
        if (block.getBlockType().equals("digitalInput") || block.getBlockType().equals("inversedDigitalInput")) {
            return this.makeDigitalInputBlockGenusFromTemplate(this.digitalInputBlockGenusTemplate, block);
        }
        if (block.getBlockType().equals("digitalOutput") || block.getBlockType().equals("inversedDigitalOutput")) {
            return this.makeDigitalInputBlockGenusFromTemplate(this.digitalOutputBlockGenusTemplate, block);
        }
        return null;
    }

    private String makeDigitalInputBlockGenusFromTemplate(String blockGenusTemplate, BlockDescription block) {
        String ret = blockGenusTemplate;
        ret = ret.replaceAll("#block_genus_name#", block.getBlockGenusName());
        ret = ret.replaceAll("#block_image_path#", block.getBlockImagePath());
        ret = ret.replaceAll("#block_color#", block.getBlockColor());
        return ret;
    }

    private void output(OutputSet outputSet) {
        this.outputSection(outputSet.getBlockGenusList());
        this.outputSection(outputSet.getBlockDrawerList());
        this.outputSection(outputSet.getBlockNameList());
        this.outputSection(outputSet.getBlockDescriptionList());
        this.outputSection(outputSet.getBlockTypeList());
    }

    private void outputSection(List<String> section) {
        for (String entry : section) {
            System.out.println(entry);
        }
        System.out.println();
    }
}

