/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.util.codegen;

import com.ardublock.util.codegen.BlockDescription;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XlsReader {
    private String xlsFilePath;
    private Sheet sheet;
    private Row row;

    public void setFilePath(String xlsFilePath) {
        this.xlsFilePath = xlsFilePath;
    }

    public void reset() throws InvalidFormatException, IOException {
        this.setupXls();
        this.seekLineTo(0);
    }

    private void setupXls() throws IOException, InvalidFormatException {
        File xlsFile = new File(this.xlsFilePath);
        FileInputStream fis = new FileInputStream(xlsFile);
        Workbook wb = WorkbookFactory.create((InputStream)fis);
        this.sheet = wb.getSheetAt(0);
    }

    private void seekLineTo(int lineId) {
        this.row = this.sheet.getRow(lineId);
    }

    public boolean hasNext() {
        if (this.row == null) {
            return false;
        }
        String firstCellContent = this.getCellContent(0);
        return firstCellContent == null || !firstCellContent.isEmpty();
    }

    private String getCellContent(int cellId) {
        Cell cell = this.row.getCell(cellId);
        if (cell == null) {
            return null;
        }
        return cell.getStringCellValue().trim();
    }

    public BlockDescription nextBlockDescription() {
        BlockDescription blockDesc = new BlockDescription();
        blockDesc.setBlockType(this.getCellContent(0));
        blockDesc.setBlockColor(this.getCellContent(1));
        blockDesc.setBlockGenusName(this.getCellContent(2));
        blockDesc.setBlockImagePath(this.getCellContent(3));
        blockDesc.setBlockShowName(this.getCellContent(4));
        blockDesc.setBlockDescription(this.getCellContent(5));
        this.seekNextRow();
        return blockDesc;
    }

    private void seekNextRow() {
        this.seekLineTo(this.row.getRowNum() + 1);
    }
}

