/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.util.translator;

import com.ardublock.util.translator.LinkedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class PropReader {
    private LinkedProperties sourceProp;
    private LinkedProperties targetProp;

    public static void main(String[] args) throws IOException {
        PropReader me = new PropReader();
        me.loadProperites("com/ardublock/block/ardublock.properties", "com/ardublock/block/ardublock_zh_CN.properties");
        me.retrieveSourceProperites();
    }

    private void retrieveSourceProperites() {
        Enumeration<Object> e = this.sourceProp.keys();
        ArrayList<Object> list = Collections.list(e);
        Collections.sort(list);
        for (String string : list) {
            String value = this.sourceProp.getProperty(string);
            if (this.targetProp.containsKey(string)) {
                value = this.targetProp.getProperty(string);
            }
            System.out.println(String.format("%s=%s", string, value));
        }
    }

    private void loadProperites(String sourcePropFileName, String targetPropFileName) throws IOException {
        InputStream sis = this.getClass().getClassLoader().getResourceAsStream(sourcePropFileName);
        this.sourceProp = new LinkedProperties();
        this.sourceProp.load(sis);
        InputStream tis = this.getClass().getClassLoader().getResourceAsStream(targetPropFileName);
        this.targetProp = new LinkedProperties();
        this.targetProp.load(tis);
    }
}

