/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import java.util.ArrayList;
import java.util.List;

public class Variable
implements Comparable<Variable> {
    private String name;
    private VariableType type;
    private VariableScope scope;
    private boolean isList;

    public Variable(String name, VariableType type, VariableScope scope, boolean isList) {
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.isList = isList;
    }

    public Variable(String name, String type, String scope) {
        this.name = name;
        if (type.startsWith("number")) {
            this.type = VariableType.NUMBER;
        } else if (type.startsWith("boolean")) {
            this.type = VariableType.BOOLEAN;
        } else if (type.startsWith("string")) {
            this.type = VariableType.STRING;
        } else assert (false);
        this.isList = type.endsWith("list");
        if (scope.equals("global")) {
            this.scope = VariableScope.GLOBAL;
        } else if (scope.equals("local")) {
            this.scope = VariableScope.LOCAL;
        } else assert (false);
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public VariableScope getScope() {
        return this.scope;
    }

    public boolean isList() {
        return this.isList;
    }

    @Override
    public int compareTo(Variable v) {
        return this.name.compareTo(v.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable v = (Variable)o;
        return this.name.equals(v.name) && this.type.equals((Object)v.type) && this.scope.equals((Object)v.scope) && this.isList == v.isList;
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode() * (this.scope.ordinal() + 1) + (this.isList ? 52933 : 99102);
    }

    public String getScopeString() {
        switch (this.scope) {
            case GLOBAL: {
                return "global";
            }
            case LOCAL: {
                return "local";
            }
        }
        return "<unknown scope>";
    }

    public String getTypeString() {
        String typeName = null;
        switch (this.type) {
            case NUMBER: {
                typeName = "number";
                break;
            }
            case BOOLEAN: {
                typeName = "boolean";
                break;
            }
            case STRING: {
                typeName = "string";
                break;
            }
            default: {
                typeName = "<unknown type>";
            }
        }
        if (this.isList) {
            typeName = String.valueOf(typeName) + "-list";
        }
        return typeName;
    }

    public String toString() {
        String scopeName = this.getScopeString();
        String typeName = this.getTypeString();
        return String.valueOf(scopeName) + "-" + typeName + (this.isList ? "-" : "-var-") + this.name;
    }

    public List<String> toList() {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.name);
        strs.add(this.getTypeString());
        strs.add(this.getScopeString());
        return strs;
    }

    public static Variable fromList(List<?> l) {
        if (l.size() != 3) {
            return null;
        }
        String n = Variable.getString(l, 0);
        String t = Variable.getString(l, 1);
        String s = Variable.getString(l, 2);
        if (n == null || t == null || s == null) {
            return null;
        }
        return new Variable(n, t, s);
    }

    private static String getString(List<?> l, int i) {
        Object o = l.get(i);
        if (!(o instanceof String)) {
            return null;
        }
        return (String)o;
    }

    public static enum VariableScope {
        GLOBAL,
        LOCAL;

    }

    public static enum VariableType {
        NUMBER,
        BOOLEAN,
        STRING,
        LIST;

    }
}

