/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CGraphite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;

public class CMenuItem
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 328149080429L;
    private Color background = CGraphite.blue;
    private Color highlight = CGraphite.white;
    private boolean focus = false;
    Position textPosition;

    public CMenuItem(String text) {
        this(text, Position.LEFT);
    }

    public CMenuItem(String text, Position position) {
        super.setText(text);
        super.setOpaque(false);
        this.addMouseListener(this);
        this.textPosition = position;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.focus) {
            g2.setColor(this.background);
        } else {
            g.setColor(this.highlight);
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        String text = this.getText();
        if (text != null) {
            Font font = g2.getFont().deriveFont((float)((double)this.getHeight() * 0.8));
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics();
            Rectangle2D textBounds = metrics.getStringBounds(this.getText(), g2);
            double textHeight = textBounds.getHeight();
            double textWidth = textBounds.getWidth() > (double)this.getWidth() ? (double)(this.getWidth() / 2) : textBounds.getWidth();
            float y = (float)((double)(this.getHeight() / 2) + textHeight / 2.0) - (float)metrics.getDescent();
            float x = this.textPosition == Position.LEFT ? 10.0f : (float)((double)(this.getWidth() / 2) - textWidth / 2.0);
            g2.setColor(Color.black);
            g2.drawString(text, x, y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.focus = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.focus = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public static enum Position {
        CENTER,
        LEFT;

    }
}

