/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.CTracklessScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CTable
extends JPanel {
    private static final long serialVersionUID = 328149080251L;
    private static final int COLUMN_WIDTH = 50;
    private static final int ROW_HEIGHT = 15;
    private static final Color foreground = Color.white;
    private static final Font font = new Font("Ariel", 1, 12);
    private final List<double[]> data;
    private final JComponent view;
    private final JComponent scroll;
    private String[] columns = new String[0];
    private JLabel[] columnLabels = new JLabel[0];

    public CTable() {
        this(9);
    }

    public CTable(int i) {
        super(new BorderLayout());
        this.data = new ArrayList<double[]>();
        this.view = new JPanel();
        this.view.setBackground(foreground);
        this.scroll = new CTracklessScrollPane(this.view, CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED, i, CGraphite.blue, new Color(100, 100, 100));
        this.add((Component)this.scroll, "Center");
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.view.addMouseListener(l);
    }

    public void setColumns(String[] columns) {
        this.data.clear();
        this.view.removeAll();
        this.view.setLayout(new GridLayout(0, columns.length));
        this.columnLabels = new JLabel[columns.length];
        int i = 0;
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            JLabel label = new JLabel(name, 0);
            label.setFont(font);
            label.setForeground(foreground);
            label.setOpaque(true);
            label.setBackground(CGraphite.blue);
            label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLUE));
            this.view.add(label);
            this.columnLabels[i] = label;
            ++i;
            ++n2;
        }
        this.columns = columns;
        this.view.setPreferredSize(new Dimension(columns.length * 50, 30));
        this.scroll.revalidate();
    }

    public void updateColumns(String[] columns) {
        this.columns = columns;
        int i = 0;
        while (i < columns.length) {
            this.columnLabels[i].setText(columns[i]);
            ++i;
        }
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    public void clearTable() {
        this.setColumns(this.columns);
    }

    public void addRow(double[] datum) {
        int i = 0;
        while (i < this.columns.length) {
            JLabel label = i < datum.length ? new JLabel(Double.toString(datum[i]), 0) : new JLabel();
            label.setOpaque(true);
            if (i == 0) {
                label.setFont(font);
                label.setBackground(CGraphite.blue);
                label.setForeground(foreground);
                label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLUE));
            } else {
                label.setFont(font);
                label.setBackground(CGraphite.gray);
                label.setForeground(foreground);
                label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLUE));
            }
            this.view.add(label);
            ++i;
        }
        this.data.add(datum);
        this.view.setPreferredSize(new Dimension(this.columns.length * 50, 15 * (1 + this.data.size())));
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    public String getCSV() {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < this.columns.length) {
            output.append(String.valueOf(this.columns[i]) + ",");
            ++i;
        }
        output.append("\n");
        for (double[] datum : this.data) {
            int i2 = 0;
            while (i2 < datum.length) {
                output.append(String.valueOf(datum[i2]) + ",");
                ++i2;
            }
            output.append("\n");
        }
        output.append("\n");
        return output.toString();
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 35, 10);
    }
}

