/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GraphicsManager {
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static GraphicsDevice gs = ge.getDefaultScreenDevice();
    public static GraphicsConfiguration gc = gs.getDefaultConfiguration();
    private static final int MAX_RECYCLED_IMAGES = 50;
    private static int numRecycledImages = 0;
    private static HashMap<Dimension, List<BufferedImage>> recycledImages = new HashMap();

    public static BufferedImage getGCCompatibleImage(int width, int height) {
        List<BufferedImage> imgList = recycledImages.get(new Dimension(width, height));
        if (imgList == null || imgList.isEmpty()) {
            return gc.createCompatibleImage(width, height, 3);
        }
        --numRecycledImages;
        BufferedImage img = imgList.remove(imgList.size() - 1);
        Graphics2D g2D = img.createGraphics();
        g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
        g2D.fill(rect);
        return img;
    }

    public static void recycleGCCompatibleImage(BufferedImage img) {
        Dimension dim;
        List<BufferedImage> imgList;
        if (img == null) {
            return;
        }
        if (numRecycledImages >= 50) {
            recycledImages.clear();
        }
        if ((imgList = recycledImages.get(dim = new Dimension(img.getWidth(), img.getHeight()))) == null) {
            imgList = new ArrayList<BufferedImage>();
            recycledImages.put(dim, imgList);
        }
        imgList.add(img);
    }
}

