/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.renderable.Comment;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class CommentArrow {
    Comment comment;
    Arrow arrow;
    private boolean active = false;

    public CommentArrow(Comment comment) {
        this.comment = comment;
    }

    public void setLocation(int x, int y) {
        this.arrow.setLocation(x, y);
        this.updateArrow();
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void updateArrow() {
        Container parentContainer = this.comment.getParent();
        if (this.comment.getCommentSource() != null && parentContainer != null) {
            double dy;
            double dx;
            double length;
            Point start = this.comment.getCommentSource().getCommentLocation();
            Point end = this.comment.getLocation();
            end.translate(this.comment.getWidth() / 2, this.comment.getHeight() / 2);
            if (this.arrow == null) {
                this.arrow = new Arrow();
            }
            if (this.arrow != null && this.arrow.getParent() != null) {
                this.arrow.getParent().remove(this.arrow);
            }
            if ((length = Math.sqrt((dx = (double)(end.x - start.x)) * dx + (dy = (double)(end.y - start.y)) * dy)) > 0.0) {
                dx /= length;
                dy /= length;
            }
            this.arrow.setXpoints((int)((double)end.x - dy * 10.0), start.x, (int)((double)end.x + dy * 10.0));
            this.arrow.setYpoints((int)((double)end.y + dx * 10.0), start.y, (int)((double)end.y - dx * 10.0));
            this.arrow.updateArrow();
            if (this.arrow.getParent() == null) {
                parentContainer.add(this.arrow);
            }
            parentContainer.validate();
            parentContainer.repaint();
            this.active = true;
        }
    }

    boolean isActive() {
        return this.active;
    }

    public void setVisible(boolean b) {
        this.arrow.setVisible(b);
    }

    public Container getParent() {
        return this.arrow.getParent();
    }

    private class Arrow
    extends JComponent {
        public int[] xpoints;
        public int[] ypoints;
        int minx;
        int miny;
        private static final long serialVersionUID = 328149080427L;

        private Arrow() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2.setColor(CommentArrow.this.comment.getBorderColor().darker());
            g2.fillPolygon(this.xpoints, this.ypoints, 3);
        }

        void setXpoints(int x1, int x2, int x3) {
            this.xpoints = new int[]{x1, x2, x3};
            this.minx = Math.min(this.xpoints[0], Math.min(this.xpoints[1], this.xpoints[2]));
            this.xpoints[0] = this.xpoints[0] - this.minx;
            this.xpoints[1] = this.xpoints[1] - this.minx;
            this.xpoints[2] = this.xpoints[2] - this.minx;
        }

        void setYpoints(int y1, int y2, int y3) {
            this.ypoints = new int[]{y1, y2, y3};
            this.miny = Math.min(this.ypoints[0], Math.min(this.ypoints[1], this.ypoints[2]));
            this.ypoints[0] = this.ypoints[0] - this.miny;
            this.ypoints[1] = this.ypoints[1] - this.miny;
            this.ypoints[2] = this.ypoints[2] - this.miny;
        }

        void updateArrow() {
            int w = Math.max(this.xpoints[0], Math.max(this.xpoints[1], this.xpoints[2]));
            int h = Math.max(this.ypoints[0], Math.max(this.ypoints[1], this.ypoints[2]));
            this.setBounds(this.minx, this.miny, w, h);
        }
    }
}

