/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.RBParent;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.SearchableElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

class FactoryCanvas
extends JPanel
implements Canvas,
SearchableContainer,
RBParent,
ComponentListener {
    private static final long serialVersionUID = 328149080291L;
    private static final int BORDER_WIDTH = 10;
    private Color highlight = null;
    private Color color;
    private final Integer BLOCK_HIGHLIGHT_LAYER = new Integer(0);
    private final Integer BLOCK_LAYER = new Integer(1);

    FactoryCanvas(String name, Color color) {
        this.setBackground(Color.green);
        this.setName(name);
        this.setColor(color);
        this.setLayout(null);
    }

    FactoryCanvas(String name) {
        this(name, CGraphite.blue);
    }

    @Override
    public Iterable<? extends SearchableElement> getSearchableElements() {
        return this.getBlocks();
    }

    ArrayList<RenderableBlock> getBlocks() {
        ArrayList<RenderableBlock> list = new ArrayList<RenderableBlock>();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof RenderableBlock) {
                list.add((RenderableBlock)comp);
            }
            ++n2;
        }
        return list;
    }

    @Override
    public void updateContainsSearchResults(boolean containsSearchResults) {
        Color previousHighlight = this.highlight;
        if (containsSearchResults) {
            this.setHighlight(Color.yellow);
        } else {
            this.setHighlight(null);
        }
        this.firePropertyChange("label_change_property", this.highlight, previousHighlight);
    }

    void setHighlight(Color highlight) {
        this.highlight = highlight;
    }

    @Override
    public Color getHighlight() {
        return this.highlight;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color == null ? CGraphite.blue : color;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.repaint();
    }

    void addBlock(RenderableBlock block) {
        if (block == null || Block.NULL.equals(block.getBlockID())) {
            return;
        }
        this.addToBlockLayer(block);
        block.setHighlightParent(this);
        block.addComponentListener(this);
    }

    void removeBlock(RenderableBlock block) {
        if (block == null || Block.NULL.equals(block.getBlockID())) {
            return;
        }
        this.remove(block);
        block.setHighlightParent(this);
        block.removeComponentListener(this);
    }

    void layoutBlocks() {
        int maxWidth = 20;
        int tx = 10;
        int ty = 10;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof RenderableBlock) {
                RenderableBlock rb = (RenderableBlock)c;
                rb.setBounds(tx, ty, rb.getBlockWidth(), rb.getBlockHeight());
                ty = ty + 10 + rb.getBlockHeight();
                rb.repaint();
                if (maxWidth < rb.getBlockWidth() + 10) {
                    maxWidth = rb.getBlockWidth() + 10;
                }
            }
            ++n2;
        }
        this.setPreferredSize(new Dimension(maxWidth, ty));
    }

    @Override
    public void addToBlockLayer(Component c) {
        this.add(c, this.BLOCK_LAYER);
    }

    @Override
    public void addToHighlightLayer(Component c) {
        this.add(c, this.BLOCK_HIGHLIGHT_LAYER);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.layoutBlocks();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

