/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.renderable.FactoryRenderableBlock;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.FactoryManager;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.Workspace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageDrawerLoadingUtils {
    private static Pattern attrExtractor = Pattern.compile("\"(.*)\"");

    private static String getNodeValue(Node node, String nodeKey) {
        Matcher nameMatcher;
        Node opt_item = node.getAttributes().getNamedItem(nodeKey);
        if (opt_item != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
            return nameMatcher.group(1);
        }
        return null;
    }

    private static Color getColorValue(Node node, String nodeKey) {
        StringTokenizer col;
        String color = PageDrawerLoadingUtils.getNodeValue(node, nodeKey);
        if (color != null && (col = new StringTokenizer(color)).countTokens() == 3) {
            return new Color(Integer.parseInt(col.nextToken()), Integer.parseInt(col.nextToken()), Integer.parseInt(col.nextToken()));
        }
        return null;
    }

    public static boolean getBooleanValue(Node node, String nodeKey) {
        String bool = PageDrawerLoadingUtils.getNodeValue(node, nodeKey);
        return bool == null || !"no".equals(bool);
    }

    private static int getIntValue(Node node, String nodeKey) {
        String num = PageDrawerLoadingUtils.getNodeValue(node, nodeKey);
        if (num != null) {
            return Integer.parseInt(num);
        }
        return 0;
    }

    public static void loadPagesAndDrawers(Workspace workspace, Element root, FactoryManager manager) {
        ArrayList<Page> pageList = new ArrayList<Page>();
        LinkedHashMap blocksForDrawers = new LinkedHashMap();
        LinkedHashMap<Page, ArrayList<RenderableBlock>> blocksForPages = new LinkedHashMap<Page, ArrayList<RenderableBlock>>();
        NodeList pagesRoot = root.getElementsByTagName("Pages");
        if (pagesRoot != null) {
            Matcher nameMatcher;
            boolean isBlankPage = false;
            Node pagesNode = pagesRoot.item(0);
            if (pagesNode == null) {
                return;
            }
            Node opt_item = pagesNode.getAttributes().getNamedItem("drawer-with-page");
            if (opt_item != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = Workspace.everyPageHasDrawer = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = pagesNode.getAttributes().getNamedItem("is-blank-page")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                isBlankPage = nameMatcher.group(1).equals("yes");
            }
            boolean collapsiblePages = PageDrawerLoadingUtils.getBooleanValue(pagesNode, "collapsible-pages");
            NodeList pages = pagesNode.getChildNodes();
            int i = 0;
            while (i < pages.getLength()) {
                Node pageNode = pages.item(i);
                if (pageNode.getNodeName().equals("Page")) {
                    String pageName = PageDrawerLoadingUtils.getNodeValue(pageNode, "page-name");
                    Color pageColor = PageDrawerLoadingUtils.getColorValue(pageNode, "page-color");
                    int pageWidth = PageDrawerLoadingUtils.getIntValue(pageNode, "page-width");
                    String pageDrawer = PageDrawerLoadingUtils.getNodeValue(pageNode, "page-drawer");
                    boolean pageInFullView = PageDrawerLoadingUtils.getBooleanValue(pageNode, "page-infullview");
                    String pageId = PageDrawerLoadingUtils.getNodeValue(pageNode, "page-id");
                    Page page = new Page(workspace, pageName, pageWidth, 0, pageDrawer, pageInFullView, pageColor, collapsiblePages);
                    page.setPageId(pageId);
                    NodeList pageNodes = pageNode.getChildNodes();
                    Object drawer = null;
                    if (Workspace.everyPageHasDrawer) {
                        manager.addDynamicDrawer(page.getPageDrawer());
                        ArrayList<FactoryRenderableBlock> drawerBlocks = new ArrayList<FactoryRenderableBlock>();
                        int k = 0;
                        while (k < pageNodes.getLength()) {
                            Node drawerNode = pageNodes.item(k);
                            if (drawerNode.getNodeName().equals("PageDrawer")) {
                                NodeList genusMembers = drawerNode.getChildNodes();
                                int j = 0;
                                while (j < genusMembers.getLength()) {
                                    Node genusMember = genusMembers.item(j);
                                    if (genusMember.getNodeName().equals("BlockGenusMember")) {
                                        String genusName = genusMember.getTextContent();
                                        assert (workspace.getEnv().getGenusWithName(genusName) != null) : "Unknown BlockGenus: " + genusName;
                                        Block block = new Block(workspace, genusName);
                                        drawerBlocks.add(new FactoryRenderableBlock(workspace, manager, block.getBlockID()));
                                    }
                                    ++j;
                                }
                                blocksForDrawers.put(drawer, drawerBlocks);
                                break;
                            }
                            ++k;
                        }
                    }
                    if (isBlankPage) {
                        workspace.putPage(page, 0);
                        break;
                    }
                    int position = pageList.size();
                    if (position == 0) {
                        workspace.putPage(page, 0);
                    } else {
                        workspace.addPage(page, position);
                    }
                    pageList.add(position, page);
                    blocksForPages.put(page, page.loadPageFrom(pageNode, false));
                }
                ++i;
            }
            for (String d : blocksForDrawers.keySet()) {
                manager.addDynamicBlocks((Collection)blocksForDrawers.get(d), d);
            }
            for (Page p : blocksForPages.keySet()) {
                p.addLoadedBlocks((Collection)blocksForPages.get(p), false);
            }
        }
    }

    public static void loadBlockDrawerSets(Workspace workspace, Element root, FactoryManager manager) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        NodeList drawerSetNodes = root.getElementsByTagName("BlockDrawerSet");
        int i = 0;
        while (i < drawerSetNodes.getLength()) {
            Node drawerSetNode = drawerSetNodes.item(i);
            if (drawerSetNode.getNodeName().equals("BlockDrawerSet")) {
                NodeList drawerNodes = drawerSetNode.getChildNodes();
                int j = 0;
                while (j < drawerNodes.getLength()) {
                    Node drawerNode = drawerNodes.item(j);
                    if (drawerNode.getNodeName().equals("BlockDrawer")) {
                        Node colorNode;
                        String drawerName = null;
                        Color buttonColor = Color.blue;
                        Matcher nameMatcher = attrExtractor.matcher(drawerNode.getAttributes().getNamedItem("name").toString());
                        if (nameMatcher.find()) {
                            drawerName = nameMatcher.group(1);
                        }
                        if ((colorNode = drawerNode.getAttributes().getNamedItem("button-color")) != null && (nameMatcher = attrExtractor.matcher(colorNode.toString())).find()) {
                            StringTokenizer col = new StringTokenizer(nameMatcher.group(1));
                            buttonColor = col.countTokens() == 3 ? new Color(Integer.parseInt(col.nextToken()), Integer.parseInt(col.nextToken()), Integer.parseInt(col.nextToken())) : Color.BLACK;
                        }
                        manager.addStaticDrawer(drawerName, buttonColor);
                        NodeList drawerBlocks = drawerNode.getChildNodes();
                        ArrayList<RenderableBlock> drawerRBs = new ArrayList<RenderableBlock>();
                        int k = 0;
                        while (k < drawerBlocks.getLength()) {
                            Node blockNode = drawerBlocks.item(k);
                            if (blockNode.getNodeName().equals("BlockGenusMember")) {
                                String genusName = blockNode.getTextContent();
                                assert (workspace.getEnv().getGenusWithName(genusName) != null) : "Unknown BlockGenus: " + genusName;
                                Block newBlock = new Block(workspace, genusName, false);
                                drawerRBs.add(new FactoryRenderableBlock(workspace, manager, newBlock.getBlockID()));
                            }
                            ++k;
                        }
                        manager.addStaticBlocks(drawerRBs, drawerName);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

