
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     16/12/2015
   Fichier :  Plate-forme_elevatrice_5.INO
   Document : Dossier BE-AUTOHANDI Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur	              Variable Arduino	Broche AutoProg Uno

Fin de course bas nacelle 	    fdc_bas                 A0
Fin de course haut nacelle   	  fdc_haut                A1
Bouton poussoir bas	            bp_bas	                A2
Bouton poussoir haut	          bp_haut	                A3
Bouton poussoir nacelle         bp_nacelle	            A4
Bouton poussoir	urgence         bp_urgence	            A5


Module actionneur	        Variable Arduino	Broche AutoProg Uno

Moteur sens descente          descendre	                9
Moteur sens montée	          monter	                  10
Module gyrophare              gyrophare                 4
		


------------------------------------------------------------------------------------------------------------------------------
*/

//Définition des variables, constantes et pin :


// Pin d'entrées
const int fdc_bas       = A0; 
const int fdc_haut      = A1;
const int bp_bas        = A2;
const int bp_haut       = A3;
const int bp_nacelle    = A4;
const int bp_urgence    = 3;



//Pin de sorties
const int descendre     = 9; 
const int monter        = 10; 
const int gyrophare     = 4; 


//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées
    pinMode (fdc_bas, INPUT);
    pinMode (fdc_haut, INPUT);
    pinMode (bp_bas, INPUT);
    pinMode (bp_haut, INPUT);
    pinMode (bp_nacelle, INPUT);   
    pinMode (bp_urgence, INPUT); 
    
    // Définition des pins comme des sorties
    pinMode (descendre, OUTPUT);
    pinMode (monter, OUTPUT);
    pinMode (gyrophare, OUTPUT);

}



//Programme principal

//Boucle infinie

void loop(void)
{ 
 if(digitalRead(bp_bas)==1)//Si bouton poussoir bas est activé
 {
  descendre_nacelle(); // activer les moteurs sens descente
  while (digitalRead(fdc_bas)== 0){}// attendre tant que fdc_bas n'est pas activé
  arreter_nacelle();// arreter les moteurs  
 }
 
 else if(digitalRead(bp_haut)==1)//Si bouton poussoir haut est activé
 {
  monter_nacelle();// activer les moteurs sens monter
  while (digitalRead(fdc_haut)== 0){}
  arreter_nacelle(); // arreter les moteurs  
 }
 
 else if(digitalRead(bp_nacelle)==1)
 {
    if(digitalRead(fdc_haut)==1)//Si le fin de course haut est activé (nacelle en position haut)
    {
      descendre_nacelle(); // activer les moteurs sens descente
      while (digitalRead(fdc_bas)== 0){}// attendre tant que fdc_bas n'est pas activé
      arreter_nacelle();
    }
    
    else 
    {
      monter_nacelle();
      while (digitalRead(fdc_haut)== 0){}// attendre tant que fdc_haut n'est pas activé 
      arreter_nacelle();
    }    
 } 
}

// Fonctions
void monter_nacelle()
{
  digitalWrite(monter,HIGH);
  digitalWrite(descendre,LOW);
}

void descendre_nacelle()
{
  digitalWrite(descendre,HIGH);
  digitalWrite(monter,LOW);
}

void arreter_nacelle()
{
  digitalWrite(descendre,LOW);
  digitalWrite(monter,LOW);
}


