
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  Mini-serre_Seq1_toutes_options.INO
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur	              Variable Arduino	Broche AutoProg Uno

Fin de course fenêtre repliée	  fdc_fermeture	            A0
Fin de course fenêtre dépliée	  fdc_ouverture	            A1
Capteur de température	        Voir bibliothèque	        A2
Capteur d’hygrométrie	          hygrometrie	              A3
Capteur d’humidité	              humidite	                A4
Bouton poussoir	                bouton_poussoir	          3


Module actionneur	        Variable Arduino	Broche AutoProg Uno

Pompe	                        pompe	                    4
Ventilateur	                  ventilateur	              5
Brumisateur 	                brumisateur	              6
Plateau chauffant	            plateau_chaffant	        7
Afficheur OLED	              OLED	                    8
Moteur ouverture	            ouverture	                9
Moteur fermeture	            fermeture	                10
		


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque
#include <OneWire.h>// Bibliothèque capteur température
#include <DallasTemperature.h> //La bibliothèque doit être copié dans le dossier librairies du logiciel Arduino
#include <AXE133Y.h>//bibliothèque OLED

//Définition des variables, constantes et pin :

byte niveau_humidite; //Variable qui stockera le niveau d'humidité de la terre
byte niveau_hygrometrie; // Variable qui stockera le niveau d'humidité de l'air
float temperature; // Variable qui stockera la température 
volatile byte interrupt; // Variable de l'interruption



// Pin d'entrées
const int fdc_fermeture       = A0; 
const int fdc_ouverture       = A1;
const int capteur_temperature = A2;
const int hygrometrie         = A3;
const int humidite            = A4;
const int bouton_poussoir     = 3;



//Pin de sorties
const int pompe             = 4; 
const int ventilateur       = 5; 
const int brumisateur       = 6; 
const int plateau_chauffant = 7;
const int oled              = 8;
const int ouverture         = 9;
const int fermeture         = 10;



AXE133Y OLED = AXE133Y(oled);//Affectation du pin de l'écran OLED

//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées
    pinMode (fdc_fermeture, INPUT);
    pinMode (fdc_ouverture, INPUT);
    pinMode (bouton_poussoir, INPUT);
    pinMode (hygrometrie, INPUT);
    pinMode (humidite, INPUT);   
    
    // Définition des pins comme des sorties
    pinMode (pompe, OUTPUT);
    pinMode (ventilateur, OUTPUT);
    pinMode (brumisateur, OUTPUT);
    pinMode (plateau_chauffant, OUTPUT);
    pinMode (ouverture, OUTPUT);
    pinMode (fermeture, OUTPUT);
    
    OLED.clearScreen();

    OLED.cursorPosition(1,0);
    OLED.print("Mini Serre"); 
    OLED.cursorPosition(2,0);
    OLED.print("A4 Technologie"); 
    OLED.cursorPosition(3,0);
    OLED.print("Appuyer sur le BP");
    OLED.cursorPosition(4,0);
    OLED.print("pour actualiser");  
    
    //Interruption sur le bouton poussoir
    attachInterrupt(1, interruption, RISING); //Aller dans la fonction interruption() lorsque le bouton poussoir est activé
}



//Programme principal

//Boucle infinie

void loop(void)
{ 

  gestion_temperature(); // Aller dans la fonction gestion_temperature();
  
  gestion_hygrometrie(); // Aller dans la fonction gestion_hygrometrie();
  
  gestion_humidite_terre(); // Aller dans la fonction gestion_humidite_air();

}

// Fonctions

void gestion_hygrometrie() // fonction gestion de l'humidité de l'air
{
  niveau_hygrometrie = analogRead(hygrometrie); // variable niveau_hygrometrie contenant le niveau d'humidité dans l'air
  Serial.println(niveau_hygrometrie); // Affichage du niveau d'humidité dans l'air
  
  if (niveau_hygrometrie<117) // Si le niveau d'humidité de l'air est inférieur à 50% (117 = 50%)
  {
    digitalWrite(brumisateur,HIGH);  // Activer le brumisateur
  }
   
  else  
  {
    digitalWrite(brumisateur,LOW);  // Désactiver le brumisateur
  }
}  
  
void gestion_humidite_terre() // fonction gestion de l'hygrometrie
{ 
  
  niveau_humidite = analogRead(humidite); // variable niveau_humidite contenant le niveau d'humidité dans la terre
  niveau_humidite=niveau_humidite/6.2;// Calcul pour avoir le niveau d'humidité en %
  if (niveau_humidite>100)
  {
    niveau_humidite = 100; // Certaines valeurs peuvent être supérieur à 100% (impossible) si une valeur dépasee, mise au maximum du niveau d'humidité
  }  
  Serial.println(niveau_humidite); // Affichage du niveau d'humidité dans la terre
  
  if (niveau_humidite<0) // Si le niveau d'humidité de la terre est inférieur à 50% 
  {
    digitalWrite(pompe,HIGH);  // Activer la pompe
    delay (1000); // Activation de la pompe pendant 1 seconde
    digitalWrite(pompe,LOW);  // Arrêt de la pompe
    delay (5000); // Attendre 5 secondes le temps que l'eau se propage
  }
  
  else 
  {
    delay(1000); // Si non attendre 6 secondes
  }
}  
    
void gestion_temperature() // fonction gestion_temperature
{
   // Déclare une variable temperature dans laquelle sera stockée la température du capteur DS18B20
  temperature=calcul_temperature();// Aller dans la fonstion calcul_temperature
  Serial.println(temperature); // Affichage de la temperature sur le moniteur série
  
  if (temperature > 25) // Si la température dépasse les 25 °C
  {
    digitalWrite(ventilateur,HIGH); // Activer le ventilateur
    digitalWrite(plateau_chauffant,LOW); // Désactiver le plateau chauffant
    while (digitalRead(fdc_ouverture)==LOW)// Exécuter les commandes tant que le fdc_ouverture n'est pas activé
    {
      digitalWrite(ouverture,HIGH);  // Ouverture de la fenêtre
    }
    digitalWrite(ouverture,LOW); // Arrêt du moteur
  }
  
    else if (temperature<20)// Si la temperature est inférieure à 20°C
  {
    digitalWrite(ventilateur,LOW); // Désactiver le ventilateur
    digitalWrite(plateau_chauffant,HIGH); // Activer le plateau chauffant
    while (digitalRead(fdc_fermeture)==LOW)// Exécuter les commandes tant que le fdc_fermeture n'est pas activé
    {
      digitalWrite(fermeture,HIGH);  // Fermeture de la fenêtre
    }

    digitalWrite(fermeture,LOW); // Arrêt du moteur
  }
  
  else // Si la temperature est inférieur ou égale à 25°C
  {
    digitalWrite(ventilateur,LOW); // Désactiver le ventilateur
    digitalWrite(plateau_chauffant,LOW); // Désactiver le plateau chauffant
  }  
}



float calcul_temperature()//fonction qui mesure la température du capteur DS1820 et renvoi la temperature dans un float
{
  OneWire oneWire(capteur_temperature);
  DallasTemperature sensors(&oneWire);// Définition du capteur de température
  sensors.begin();// Activation des mesures du capteur de température 
  float temperature;
  sensors.requestTemperatures();  
  temperature=sensors.getTempCByIndex(0);
  return (temperature);
}


void interruption()
{
    //valeurs mesurées par les capteurs
    niveau_hygrometrie = analogRead(hygrometrie); // variable niveau_hygrometrie contenant le niveau d'humidité dans la terre
    niveau_hygrometrie = (((niveau_hygrometrie)*0.4) -3); // Calcul pour passer le niveau d'hygrométrie en %
    Serial.println(niveau_hygrometrie);
    temperature=calcul_temperature();
    niveau_humidite = analogRead(humidite);
  
  //Affichage sur l'écran OLED
    OLED.clearScreen();
    OLED.cursorPosition(1,0);//Texte ligne 1 
    OLED.print("Temperature ");
    OLED.print(String(temperature));
    OLED.print(" C");
    
    OLED.cursorPosition(2,0);// Tesxte ligne 2 
    OLED.print("Humidite : ");
    OLED.print(String(niveau_humidite));
    OLED.print(" %"); 
    
    OLED.cursorPosition(3,0);// Texte ligne 3
    OLED.print("Hygrometrie : ");
    OLED.print(String(niveau_hygrometrie));
    OLED.print(" %"); 
    
    OLED.cursorPosition(4,0);// Texte ligne 4
    OLED.print("Appui BP actualiser");
  
}
