
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  _2_Mini-serre_Seq2_Regulation_taux_humidite_corrige.INO
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque

//Définition des variables, constantes et pin :

int niveau_humidite; // Variable qui stockera le niveau d'humidité de la terre


// Pin d'entrées

const int humidite            = A4;

//Pin de sorties

const int pompe               = 4;

//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées

    
     
    // Définition des pins comme des sorties
    pinMode (pompe, OUTPUT);  

    
}



//Programme principal

//Boucle infinie

void loop(void)
{ 

  niveau_humidite = analogRead(humidite); // variable niveau_humidite contenant le niveau d'humidité dans la terre
  niveau_humidite=niveau_humidite/6.2;// Calcul pour avoir le niveau d'humidité en %
  if (niveau_humidite>100)
  {
    niveau_humidite = 100; // Certaines valeurs peuvent être supérieur à 100% (impossible) si une valeur dépasee, mise au maximum du niveau d'humidité
  }  
  Serial.println(niveau_humidite);

  if (niveau_humidite<50) // Si le niveau d'humidité de la terre est inférieur à 50% 
  {
    digitalWrite(pompe,HIGH);  // Activer la pompe
    delay (1000); // Activation de la pompe pendant 1 seconde
    digitalWrite(pompe,LOW);  // Arrêt de la pompe
    delay (5000); // Attendre 5 secondes le temps que l'eau se propage
  }
}

// Fonctions
  




