
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  3_Mini-serre Seq 3 Controle temperature maximale corrige.INO
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque
#include <OneWire.h>// Bibliothèque capteur température
#include <DallasTemperature.h> //La bibliothèque doit être copié dans le dossier librairies du logiciel Arduino


//Définition des variables, constantes et pin :

float temperature; // Variable qui stockera la température 

// Pin d'entrées
const int fdc_fermeture       = A0; 
const int fdc_ouverture       = A1;
const int capteur_temperature = A2;

//Pin de sorties

const int ventilateur       = 5; 
const int ouverture         = 9;
const int fermeture         = 10;





//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées
    pinMode (fdc_fermeture, INPUT);
    pinMode (fdc_ouverture, INPUT);

    
    // Définition des pins comme des sorties

    pinMode (ventilateur, OUTPUT);
    pinMode (ouverture, OUTPUT);
    pinMode (fermeture, OUTPUT);
}



//Programme principal

//Boucle infinie

void loop(void)
{ 
  temperature=calcul_temperature();// Aller dans la fonstion calcul_temperature
  Serial.print(temperature); // Affichage de la temperature sur le moniteur série
  
  if (temperature > 25) // Si la température dépasse les 25 °C
  {
    digitalWrite(ventilateur,HIGH); // Activer le ventilateur
    while (digitalRead(fdc_ouverture)==LOW)// Exécuter les commandes tant que le fdc_ouverture n'est pas activé
    {
      digitalWrite(ouverture,HIGH);  // Ouverture de la fenêtre
    }
    digitalWrite(ouverture,LOW); // Arrêt du moteur
  }
  
  else // Si la temperature est inférieur ou égale à 25°C
  {
    digitalWrite(ventilateur,LOW); // Désactiver le ventilateur
    while (digitalRead(fdc_fermeture)==LOW)// Exécuter les commandes tant que le fdc_fermeture n'est pas activé
    {
      digitalWrite(fermeture,HIGH);  // Fermeture de la fenêtre
    }
    digitalWrite(fermeture,LOW); // Arrêt du moteur
  }
}


// Fonctions

float calcul_temperature()//fonction qui mesure la température du capteur DS1820 et renvoi la temperature dans un float
{
  OneWire oneWire(capteur_temperature);
  DallasTemperature sensors(&oneWire);// Définition du capteur de température
  sensors.begin();// Activation des mesures du capteur de température 
  float temperature;
  sensors.requestTemperatures();  
  temperature=sensors.getTempCByIndex(0);
  return (temperature);
}

