
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  _4_Mini-serre_Piste1_affichage_temperature.INO
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque
#include <OneWire.h>// Bibliothèque capteur température
#include <DallasTemperature.h> //La bibliothèque doit être copié dans le dossier librairies du logiciel Arduino


//Définition des variables, constantes et pin :

float temperature; // Variable qui stockera la température 

// Pin d'entrées

const int capteur_temperature = A2;

//Pin de sorties

const int plateau_chauffant = 7;

//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées

    
    // Définition des pins comme des sorties

    pinMode (plateau_chauffant, OUTPUT);

}



//Programme principal

//Boucle infinie

void loop(void)
{ 
 // Déclare une variable temperature dans laquelle sera stockée la température du capteur DS18B20
  temperature=calcul_temperature();// Aller dans la fonstion calcul_temperature
  Serial.print(temperature); // Affichage de la temperature sur le moniteur série
  
  if (temperature < 20) // Si la temperature est inférieur 20°C
  {    
    digitalWrite(plateau_chauffant,HIGH); // Activer le plateau chauffant
  }
  
  else if (temperature > 25) // Si la température dépasse les 25 °C
  {    
    digitalWrite(plateau_chauffant,LOW); // Désactiver le plateau chauffant
  }
}

// Fonctions

float calcul_temperature()//fonction qui mesure la température du capteur DS1820 et renvoi la temperature dans un float
{
  OneWire oneWire(capteur_temperature);
  DallasTemperature sensors(&oneWire);// Définition du capteur de température
  sensors.begin();// Activation des mesures du capteur de température 
  float temperature;
  sensors.requestTemperatures();  
  temperature=sensors.getTempCByIndex(0);
  return (temperature);
}

