
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  _5_Mini-serre_Piste2_affichage_hygrometrie.INO
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque

//Définition des variables, constantes et pin :

byte niveau_hygrometrie; //Variable qui stockera le niveau d'humidité de l'air

// Pin d'entrées

const int hygrometrie         = A3;

//Pin de sorties
 
const int brumisateur       = 6; 

//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées
    pinMode (hygrometrie, INPUT);  
    
    // Définition des pins comme des sorties
    pinMode (brumisateur, OUTPUT);
}



//Programme principal

//Boucle infinie

void loop(void)
{ 
  niveau_hygrometrie = analogRead(hygrometrie); // variable niveau_hygrometrie contenant le niveau d'humidité dans l'air
  Serial.print(niveau_hygrometrie); // Affichage du niveau d'humidité dans l'air
  
  if (niveau_hygrometrie<117) // Si le niveau d'humidité de l'air est inférieur à 50% (117 = 50%)
  {
    digitalWrite(brumisateur,HIGH);  // Activer le brumisateur
  }
   
  else  
  {
    digitalWrite(brumisateur,LOW);  // Désactiver le brumisateur
  }
}

// Fonctions


