
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier : .INO
   Document : Dossier Mini Serre Arduino
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque
#include <OneWire.h>// Bibliothèque capteur température
#include <DallasTemperature.h> //La bibliothèque doit être copié dans le dossier librairies du logiciel Arduino
#include <AXE133Y.h>//bibliothèque OLED

//Définition des variables, constantes et pin :

byte niveau_humidite; //Variable qui stockera le niveau d'humidité de la terre
float temperature; // Variable qui stockera la température 
volatile byte interrupt; // Variable de l'interruption



// Pin d'entrées

const int capteur_temperature = A2;
const int humidite            = A4;
const int bouton_poussoir     = 3;



//Pin de sorties
const int oled              = 8;




AXE133Y OLED = AXE133Y(oled);//Affectation du pin de l'écran OLED

//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées
    pinMode (bouton_poussoir, INPUT);
    pinMode (humidite, INPUT);   
    
    // Définition des pins comme des sorties

    OLED.clearScreen();

    OLED.cursorPosition(1,0);
    OLED.print("Mini Serre"); 
    OLED.cursorPosition(2,0);
    OLED.print("A4 Technologie"); 
    OLED.cursorPosition(3,0);
    OLED.print("Appuyer sur le BP");
    OLED.cursorPosition(4,0);
    OLED.print("pour actualiser");  
    
    //Interruption sur le bouton poussoir
    attachInterrupt(1, interruption, RISING); //Aller dans la fonction interruption() lorsque le bouton poussoir est activé
}



//Programme principal

//Boucle infinie

void loop(void)
{ 
// Aucune fonction dans la loop. La fonction d'affichage est gérée par l'interruption
}

// Fonctions

void interruption()
{
  static boolean x; //x prend la valeur 0 ou 1

    //valeurs mesurées par les capteurs
    niveau_humidite = analogRead(humidite); // variable niveau_humidite contenant le niveau d'humidité dans la terre
    niveau_humidite = (((niveau_humidite)*0.4) -3); // Calcul pour passer le niveau d'humidité en %
   
    temperature=calcul_temperature();


  if (x == 0)
  {
  //Affichage sur l'écran OLED
    OLED.clearScreen();
    OLED.cursorPosition(1,0);//Texte ligne 1 
    OLED.print("Temperature ");
    OLED.print(String(temperature));
    OLED.print(" C");
    
    OLED.cursorPosition(2,0);// Tesxte ligne 2 
    OLED.print("Humidite : ");
    OLED.print(String(niveau_humidite));
    OLED.print(" %"); 
    
    OLED.cursorPosition(3,0);// Texte ligne 3
    OLED.print("Appuyer sur le BP");

    OLED.cursorPosition(4,0);// Texte ligne 4
    OLED.print("Pour eteindre");
    
    x= 1; //X = 1 pour le prochain appui sur le BP, éteindre l'écran
  }

  else if (x == 1)
  {  
    OLED.clearScreen();
    x=0; //X = 0 pour le prochain appui sur le BP, voir les mesures 
  }
}

float calcul_temperature()//fonction qui mesure la température du capteur DS1820 et renvoi la temperature dans un float
{
  OneWire oneWire(capteur_temperature);
  DallasTemperature sensors(&oneWire);// Définition du capteur de température
  sensors.begin();// Activation des mesures du capteur de température 
  float temperature;
  sensors.requestTemperatures();  
  temperature=sensors.getTempCByIndex(0);
  return (temperature);
}



