package fr.a4.portail_coulissant_1_bouton;


import fr.a4.telecommande.R;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;


public class MainActivity extends Activity {
	Button bouton_commande;
	TextView etat_wifi;
	EditText octet_commande;
	int code_envoye_octet;
	NetworkTask networktask;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		bouton_commande=(Button)findViewById(R.id.b_commande);
		etat_wifi=(TextView)findViewById(R.id.statut_wifi);
		octet_commande=(EditText)findViewById(R.id.code_envoye);
		bouton_commande.setOnClickListener(commande_listener);
		networktask = new NetworkTask();
		networktask.execute();
	}

	private OnClickListener commande_listener = new OnClickListener() {
		@Override
		public void onClick(View v){
			// TODO Auto-generated method stub
			code_envoye_octet=Integer.parseInt(octet_commande.getText().toString());
			networktask.SendDataToNetwork((byte)code_envoye_octet);
		}
	};
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public class NetworkTask extends AsyncTask<Void, byte[], Boolean> {
		
		Socket nsocket; //Network Socket
		InputStream nis; //Network Input Stream
		OutputStream nos; //Network Output Stream 
		@Override
		protected void onPreExecute() {
		}
		@Override
		// >>> Partie executee dans un autre Thread >>>>
	    protected Boolean doInBackground(Void... params) { 
	        boolean result = false;
	        try {
	        		SocketAddress sockaddr = new InetSocketAddress("192.168.16.254", 5000);
	        		nsocket = new Socket();
	        		nsocket.connect(sockaddr, 5000); //5 seconds connection timeout
	        		if (nsocket.isConnected()) { 
	        			etat_wifi.setText("Connecte au portail");
	        			nis = nsocket.getInputStream();
	        			nos = nsocket.getOutputStream();
	        			byte[] buffer = new byte[4096];
	        			int read = nis.read(buffer, 0, 4096); 
	        			while(read != -1){
	        				byte[] tempdata = new byte[read];
	        				System.arraycopy(buffer, 0, tempdata, 0, read);
	        				publishProgress(tempdata);
	        				read = nis.read(buffer, 0, 4096); 
	        			} 
	            }
	        } catch (IOException e) {
	            e.printStackTrace();
	            result = true;
	        } catch (Exception e) {
	            e.printStackTrace();
	            result = true;
	        } finally {
	            try {
	                nis.close();
	                nos.close();
	                nsocket.close();
	            } catch (IOException e) {
	                e.printStackTrace();
	            } catch (Exception e) {
	                e.printStackTrace();
	            }
	        }
	        return result;
	    } // <<< doInBackground <<<<<<<<<<<<<<<<<<<<<<<<<<<<
	
		public void SendDataToNetwork(byte commande_portail) {
		String cmd=""; // "i" caractre de synchro de dpart de tramme envoye
		try {
			if (nsocket.isConnected()) {
				//on fabrique la trame de commande
				cmd=(char)commande_portail+ cmd;	
				nos.write(cmd.getBytes());
			} else {
				etat_wifi.setText("Socket ferm.");
			}
		} catch (Exception e) {
			etat_wifi.setText("erreur socket");
			}
		}

		@Override
		protected void onProgressUpdate(byte[]... values) {
			//on ne reoit rien
			
		}

		@Override
		protected void onPostExecute(Boolean result) {
			if (result) {
				etat_wifi.setText("Erreur de connexion.");          
			}
		}
	} // <<< NetworkTask <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	@Override
	protected void onDestroy() {
		super.onDestroy();
		networktask.cancel(true);
	}

	
}
