// application permet de piloter un portail coulissant A4 avec 2 capteurs vantail ouvert / vantail ferm
// L'application envoie un code au module wifi picaxe
// l'application bloque les boutons de commande et attend que le portail soit totalement ouvert ou ferm
// utilise l'application picaxeeditor portail_coulissant_wifi_2_boutons_capteurs.plf

package fr.a4.portail_coulissant_2_boutons_capteurs;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;


public class MainActivity extends Activity {

	TextView connexion_wifi, etat_portail;
	EditText commande_ouvrir, commande_fermer;
	ImageButton ouvrir, fermer;
	NetworkTask networktask;
	int code_envoye_octet;
	// code reus lors de la rception venant du Picaxe
	private static final byte code_vantail_ferme = 102; //correspond au code ascii de F
	private static final byte code_vantail_ouvert = 111; //correspond au code ascii de O
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		connexion_wifi=(TextView)findViewById(R.id.etat_wifi);
		etat_portail=(TextView)findViewById(R.id.etat_portail);
		commande_ouvrir=(EditText)findViewById(R.id.commande_ouverture);
		commande_fermer=(EditText)findViewById(R.id.commande_fermeture);
		ouvrir=(ImageButton)findViewById(R.id.bouton_ouvrir);
		fermer=(ImageButton)findViewById(R.id.bouton_fermer);
		ouvrir.setOnClickListener(ouvrir_listener);
		fermer.setOnClickListener(fermer_listener);
		
		ouvrir.setClickable(true);
		fermer.setClickable(true);
		
		networktask = new NetworkTask();
		networktask.execute();
	}

	private OnClickListener ouvrir_listener = new OnClickListener() {
		@Override
		public void onClick(View v){
			etat_portail.setText("ouverture en cours...");
			ouvrir.setClickable(false);
			fermer.setClickable(false);
			code_envoye_octet=Integer.parseInt(commande_ouvrir.getText().toString());
			networktask.SendDataToNetwork((byte)code_envoye_octet);
		}
	};
	
	private OnClickListener fermer_listener = new OnClickListener() {
		@Override
		public void onClick(View v){
			etat_portail.setText("fermeture en cours...");
			ouvrir.setClickable(false);
			fermer.setClickable(false);
			code_envoye_octet=Integer.parseInt(commande_fermer.getText().toString());
			networktask.SendDataToNetwork((byte)code_envoye_octet);
		}
	};
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public class NetworkTask extends AsyncTask<Void, byte[], Boolean> {
		
		Socket nsocket; //Network Socket
		InputStream nis; //Network Input Stream
		OutputStream nos; //Network Output Stream 
		@Override
		protected void onPreExecute() {
		}
		@Override
		// >>> Partie executee dans un autre Thread >>>>
	    protected Boolean doInBackground(Void... params) { 
	        boolean result = false;
	        try {
	        		SocketAddress sockaddr = new InetSocketAddress("192.168.16.254", 5000);
	        		nsocket = new Socket();
	        		nsocket.connect(sockaddr, 5000); //5 seconds connection timeout
	        		if (nsocket.isConnected()) { 
	        			connexion_wifi.setText("Connecte au portail");
	        			nis = nsocket.getInputStream();
	        			nos = nsocket.getOutputStream();
	        			byte[] buffer = new byte[4096];
	        			int read = nis.read(buffer, 0, 4096); 
	        			while(read != -1){
	        				byte[] tempdata = new byte[read];
	        				System.arraycopy(buffer, 0, tempdata, 0, read);
	        				publishProgress(tempdata);
	        				read = nis.read(buffer, 0, 4096); 
	        			} 
	            }
	        } catch (IOException e) {
	            e.printStackTrace();
	            result = true;
	        } catch (Exception e) {
	            e.printStackTrace();
	            result = true;
	        } finally {
	            try {
	                nis.close();
	                nos.close();
	                nsocket.close();
	            } catch (IOException e) {
	                e.printStackTrace();
	            } catch (Exception e) {
	                e.printStackTrace();
	            }
	        }
	        return result;
	    } // <<< doInBackground <<<<<<<<<<<<<<<<<<<<<<<<<<<<
	
		public void SendDataToNetwork(byte commande_portail) {
		String cmd=""; // "i" caractre de synchro de dpart de tramme envoye
		try {
			if (nsocket.isConnected()) {
				//on fabrique la trame de commande
				cmd=(char)commande_portail+ cmd;	
				nos.write(cmd.getBytes());
			} else {
				connexion_wifi.setText("Socket ferm.");
			}
		} catch (Exception e) {
			connexion_wifi.setText("erreur socket");
			}
		}

		@Override
		protected void onProgressUpdate(byte[]... values) {
			if (values.length >0) {
				if (values[0].length>=1) { // on vrifie que l'on a bien reu 1 octets
			
					byte val = values[0][0];
					
					switch (val) {
						case code_vantail_ferme: { // si capteur ferm actif = portail ferm
							etat_portail.setText("Portail ferm");
							ouvrir.setClickable(true);
							fermer.setClickable(false);
							break;
						}
						case code_vantail_ouvert:{ // si capteur ouvert actif = portail ouvert
							etat_portail.setText("Portail ouvert");
							ouvrir.setClickable(false);
							fermer.setClickable(true);
							break;
						}
					}
				}
			}	
		}

		@Override
		protected void onPostExecute(Boolean result) {
			if (result) {
				connexion_wifi.setText("Erreur de connexion.");          
			}
		}
	} // <<< NetworkTask <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	@Override
	protected void onDestroy() {
		super.onDestroy();
		networktask.cancel(true);
	}
}
