package fr.a4.test_carte_wifi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Activity;
import android.graphics.Color;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;

import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity {

	TextView etat;
	Button test_bouton;
	NetworkTask networktask;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		/*
		connecte_par_fils = (CheckBox) findViewById(R.id.connecte_par_fil_ok);
		led_ok_clic = (CheckBox) findViewById(R.id.led_ok);
		led_ok_clic.setVisibility(View.INVISIBLE);
		start_parametrage = (CheckBox) findViewById(R.id.lancer_parametrage);
		start_parametrage.setVisibility(View.INVISIBLE);
		parametrage_fini = (CheckBox) findViewById(R.id.parametrage_termine);
		parametrage_fini.setVisibility(View.INVISIBLE);
		K1OFF = (CheckBox) findViewById(R.id.K1_OFF);
		K1OFF.setVisibility(View.INVISIBLE);
		
		demarrer_test = (CheckBox) findViewById(R.id.lancer_test_com);
		demarrer_test.setVisibility(View.INVISIBLE);
		*/
		etat = (TextView) findViewById(R.id.status);
		etat.setText("mise en place");
		test_bouton = (Button) findViewById(R.id.test);
		test_bouton.setOnClickListener(test_boutonListener);
		
		 /*
		connecte_par_fils.setOnClickListener(new OnClickListener() {
			
			//@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (connecte_par_fils.isChecked()) {
					led_ok_clic.setVisibility(View.VISIBLE);
					connecte_par_fils.setClickable(false);
					etat.setText("fils connects");
				}
			}
		});
		
		led_ok_clic.setOnClickListener(new OnClickListener() {
			
			//@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (led_ok_clic.isChecked()) {
					start_parametrage.setVisibility(View.VISIBLE);
					led_ok_clic.setClickable(false);
					etat.setText("Led RUN OK");
				}
			}
		});
		
		start_parametrage.setOnClickListener(new OnClickListener() {
			
			//@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (start_parametrage.isChecked()) {
					parametrage_fini.setVisibility(View.VISIBLE);
					start_parametrage.setClickable(false);
					etat.setText("dmarrage du paramtrage...");
				}
			}
		});
		
		parametrage_fini.setOnClickListener(new OnClickListener() {
			
			//@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (parametrage_fini.isChecked()) {
					K1OFF.setVisibility(View.VISIBLE);
					parametrage_fini.setClickable(false);
					etat.setText("paramtrage fini LED 2 ON");
				}
			}
		});
		
		K1OFF.setOnClickListener(new OnClickListener() {
			
			//@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (K1OFF.isChecked()) {
					demarrer_test.setVisibility(View.VISIBLE);
					K1OFF.setClickable(false);
					etat.setText("Inter K1 sur OFF");
				}
			}
		});
		
		demarrer_test.setOnClickListener(new OnClickListener() {
			//@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				if (demarrer_test.isChecked()) {
					demarrer_test.setClickable(false);
					etat.setText("test lanc");
					tache_reseau.SendDataToNetwork((byte)79);
				}
			}
		});
		*/
		networktask = new NetworkTask();
		networktask.execute();
		
		
	}
	
	private OnClickListener test_boutonListener = new OnClickListener() {
		public void onClick(View v){
			networktask.SendDataToNetwork((byte)79);
		}
	};
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
		
	public class NetworkTask extends AsyncTask<Void, byte[], Boolean> {
			
			Socket nsocket; //Network Socket
			InputStream nis; //Network Input Stream
			OutputStream nos; //Network Output Stream 
			
			@Override
			protected void onPreExecute() {
				
			}
			@Override
			// >>> Partie executee dans un autre Thread >>>>
		    protected Boolean doInBackground(Void... params) { 
		        boolean result = false;
		        try {
		        		SocketAddress sockaddr = new InetSocketAddress("192.168.16.254", 5000);
		        		nsocket = new Socket();
		        		nsocket.connect(sockaddr, 5000); //5 seconds connection timeout
		        		if (nsocket.isConnected()) { 
		        			etat.setText("Connect au wizfi630");
		        			nis = nsocket.getInputStream();
		        			nos = nsocket.getOutputStream();
		        			byte[] buffer = new byte[4096];
		        			int read = nis.read(buffer, 0, 4096); 
		        			while(read != -1){
		        				byte[] tempdata = new byte[read];
		        				System.arraycopy(buffer, 0, tempdata, 0, read);
		        				publishProgress(tempdata);
		        				read = nis.read(buffer, 0, 4096); 
		        			} 
		            }
		        } catch (IOException e) {
		            e.printStackTrace();
		            result = true;
		        } catch (Exception e) {
		            e.printStackTrace();
		            result = true;
		        } finally {
		            try {
		                nis.close();
		                nos.close();
		                nsocket.close();
		            } catch (IOException e) {
		                e.printStackTrace();
		            } catch (Exception e) {
		                e.printStackTrace();
		            }
		        }
		        return result;
		    } // <<< doInBackground <<<<<<<<<<<<<<<<<<<<<<<<<<<<
		
			public void SendDataToNetwork(byte envoi) {
			String cmd="i"; // "i" caractre de synchro de dpart de tramme envoye
			
			try {
				if (nsocket.isConnected()) {
					//on fabrique la trame de commande
					cmd=cmd+(char)envoi;	
					nos.write(cmd.getBytes());
					etat.setText("envoi effectu...");
				} else {
					etat.setText("Socket ferm.");
				}
			} catch (Exception e) {
				etat.setText("erreur socket!");
				}
			}

			@Override
			protected void onProgressUpdate(byte[]... values) {
				
				if (values.length >0) {
					if (values[0].length>=1) { // on vrifie que l'on a bien reu 1 octets
				
						byte val = values[0][0];
						//si on reoit "R" alors test OK
						if (val==82) {
							etat.setTextColor(Color.GREEN);
							
							etat.setText("Carte VALIDEE");
						}
						else {
							//mauvais octet reu!
							etat.setText("mauvaise rception!");
						}
					}
				}
			}

			/*protected void onStart(){
			
				if (networktask!=null) {
					if (networktask.isCancelled()==true) {
						networktask.execute();
					}
				}
				else
				{
					networktask = new NetworkTask(); //New instance of NetworkTask
					networktask.execute();
				}
			}*/
			
			@Override
			protected void onPostExecute(Boolean result) {
				if (result) {
					etat.setText("Erreur de connexion.");          
				}
			}
	} // <<< NetworkTask <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	@Override
	protected void onDestroy() {
		super.onDestroy();
		networktask.cancel(true);//cancel the task
	}		

}
